﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;

using GE.World;
using GE.Manager;

namespace GE.Gui
{
    /// <summary>
    /// Main menu of the game
    /// </summary>
    class WMainMenu : Window
    {
        /// <summary>
        /// Background
        /// </summary>
        WImage _background;

        /// <summary>
        /// Title
        /// </summary>
        WText _title;

        /// <summary>
        /// Button Play
        /// </summary>
        WButton _buttonPlay;

        /// <summary>
        /// Button credit
        /// </summary>
        WButton _buttonCredit;

        /// <summary>
        /// Constructor
        /// </summary>
        public WMainMenu()
        {
            _background = new WImage("Widget\\splashScreen", Vector2.Zero);
            _title = new WText(Manager.FontType.MenuTitle, "Megaman Zero", new Vector2(20, 100), Color.RosyBrown);
            _buttonPlay = new WButton(this, "Play", Color.RosyBrown, new Vector2(100, 300));
            _buttonCredit = new WButton(this, "Credit", Color.RosyBrown, new Vector2(100, 400));

            addWidget(_background);
            addWidget(_title);
            addWidget(_buttonCredit);
            addWidget(_buttonPlay);

            registerButton(_buttonPlay, null, null, null, _buttonCredit);
            registerButton(_buttonCredit, null, null, _buttonPlay, null);

            _buttonPlay.OnClick = GetType().GetMethod("onClickPlay");
            _buttonCredit.OnClick = GetType().GetMethod("onClickCredit");
        }

        /// <summary>
        /// Slot to handle the click on the play button
        /// </summary>
        public void onClickPlay()
        {
            WSelectStage selectState = new WSelectStage();
            selectState.show();
            //World.World.Instance.loadLevel("Level/lvlBombman.xml");
            
            //BulletManager.Instance.init(50);
            //ExplosionManager.Instance.init(10);

            //World.World.Instance.initialise();
            //World.World.Instance.activate();
            //World.World.Instance.startGame();

            //Gui.Instance.hideAllWindows();
        }

        /// <summary>
        /// Slot to handle the click on the credit button
        /// </summary>
        public void onClickCredit()
        {
            WCreditWindow menu = new WCreditWindow();
            menu.show();
        }

        public override void onClose()
        {
        }
    }
}
